using System;
using System.Runtime.Serialization;
using System.Security.Permissions;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.BOL
{
	
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/23/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Business Object Exception, builds information needed to define and manage a business object layer exception</summary>

		#endregion

	[Serializable]
	public class BusinessObjectException : BaseApplicationException
	{
		private string _OSVersion = Environment.OSVersion.ToString();
		private string _stackTrace = Environment.StackTrace.ToString();
		private string _machineName = Environment.MachineName.ToString();
		private string _userName = Common.LogonUser.LogonUserName;

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2071"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3019"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty constructor
		/// </summary>
		public BusinessObjectException() : base()
		{
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2073"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid BusinessObjectException object and valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2074"> 
		///		<ExpectedInput>Null value</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor with string parameter
		/// </summary>
		public BusinessObjectException(string message) : base(message)
		{
		} 

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2075"> 
		///		<ExpectedInput>Valid String and Exception</ExpectedInput>
		///		<ExpectedOutput>Valid BusinessObjectException object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2076"> 
		///		<ExpectedInput>Null message and null exception</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message and null value for inner exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor with string and exception parameters
		/// </summary>
		public BusinessObjectException(string message, Exception inner) : base(message, inner)
		{
		}

		/// <summary>
		/// BusinessObjectException
		/// </summary>
		/// <param name="info">info</param>
		/// <param name="context">context</param>
		protected BusinessObjectException(SerializationInfo info, StreamingContext context) : base (info, context)
		{  
			_OSVersion = info.GetString("_OSVersion");
			_stackTrace = info.GetString("_stackTrace");
			_machineName = info.GetString("_machineName");
			_userName = info.GetString("_userName");
		}
	

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2080"> 
		///		<ExpectedInput>Valid info and context objects</ExpectedInput>
		///		<ExpectedOutput>Valid object data in OS, user name</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3021"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// override GetObjectData to serialize state data
		/// </summary>
		[SecurityPermission(SecurityAction.Demand, SerializationFormatter = true)]
		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue("_OSVersion", _OSVersion, typeof(string));
			info.AddValue("_stackTrace", _stackTrace, typeof(string));
			info.AddValue("_machineName", _machineName, typeof(string));
			info.AddValue("_userName", _userName, typeof(string));
			base.GetObjectData(info, context);
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2079"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3026"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///	
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Operating system version
		/// </summary>
		public string OSVersion
		{
			get
			{
				return _OSVersion;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/20/2003</CreationDate>
		///<TestCases>
		///
		///	<Case type="0" testid ="2078"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///	<Case type="1" testid ="3027"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// User name
		/// </summary>
		public string UserName
		{
			get 
			{
				return _userName;
			}
		}
 	}
}
